import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {FormField} from 'react-form'
import {
    ButtonGroup, ButtonToolbar, Card, CardBody, CardText, CardTitle, FormFeedback, FormText, Modal,
    ModalBody, ModalHeader, Tooltip
} from "reactstrap";
import classNames from 'classnames';
import {graphql, compose} from "react-apollo";
import {speciesProgettoQuery} from "../../../../api/queries";
import BlinkDot from "../../../Loading/BlinkDot";
import ReactTable from "react-table";
import Ionicon from "react-ionicons";
import AcquaticaDrop from "../../../AcquaticaDrop";
import {findById} from "../../../../utils";

class SpeciesChooserWrapper extends Component {

    constructor(props) {
        super(props);

        this.state = {
            selectedItem: null,
            isTableModalOpen: false,
            columns: [
                {
                    Header: "",
                    accessor: "id",
                    width: 70,
		    Cell: row => (
			    <div>
			    	<img src={'/LifeEremitaWeb/specie/'+row.value+'.png'} />
			    </div>
		    )
                },
                {
                    Header: "Acquatica",
                    accessor: "acquatica",
                    width: 100,
                    Cell: (row) => {
                        return(<div className="text-center">
                                <AcquaticaDrop row={row}/>
                            </div>);
                    }
                },
                {
                    Header: "Specie",
                    accessor: "specie.denominazioneTaxon"
                    /*Cell: (row) => {
                        return(<div>
                            {row.original.specie.denominazioneTaxon + ' '}
                        </div>);
                    },*/
                },
                {
                    Header: "",
                    width: 120,
                    Cell: (row) => {
                        return (<ButtonGroup size={"sm"}>
                            <button onClick={() => this.onItemSelected(row.original)} className="btn btn-light">
                                Seleziona
                            </button>
                        </ButtonGroup>);
                    },
                },
            ]
        };

        this.onItemSelected = this.onItemSelected.bind(this);
        this.toggleTableModal = this.toggleTableModal.bind(this);
    }

    componentWillMount() {
        this.props.data.refetch();
    }

    async componentWillReceiveProps(nextProps) {
        if(nextProps.fieldApi.getValue()) {
            if(!this.state.selectedItem) {
                this.setState({selectedItem: nextProps.fieldApi.getValue()});
            } else if(this.state.selectedItem.id !== nextProps.fieldApi.getValue().id) {
                this.setState({selectedItem: nextProps.fieldApi.getValue()});
            }
        }

        if(!nextProps.fieldApi.getValue() && this.state.selectedItem) {
            this.setState({selectedItem: null});
        }
    }

    onItemSelected(item) {
        const {fieldApi} = this.props;

        this.setState({
            selectedItem: item,
            isTableModalOpen: false,
        });
        fieldApi.setValue(item);
	if (this.props.onChange) this.props.onChange(item)
    }

    toggleTableModal() {
        this.setState({
            isTableModalOpen: !this.state.isTableModalOpen
        });
    }

    render() {

        const {
            selectedItem,
            columns,
            isTableModalOpen,
        } = this.state;

        const {
            fieldApi,
            helpText,
            data,
	    nascondiPulsanteCambio,
            ...rest
        } = this.props;

        const {
            getError,
            getTouched,
        } = fieldApi;

        const touched = getTouched();
        const error = getError();

        const selectedSpecieProgetto = selectedItem && data.specieProgettos ? findById(data.specieProgettos, selectedItem.id): null;

        return (
            <div>
                <Card>
                    <CardBody style={{backgroundColor: "#ffffff"}}>
                        {(selectedItem && data.specieProgettos) && <CardTitle className="ionicon-center">
				<img src={'/LifeEremitaWeb/specie/'+selectedSpecieProgetto.specie.id+'.png'} style={{'marginRight':'2em'}} />
                            {selectedSpecieProgetto.specie.denominazioneTaxon}
			    
                            <AcquaticaDrop containerStyle={{marginLeft: '0.2em'}} acquatica={selectedSpecieProgetto.acquatica} specieId={selectedSpecieProgetto.id}/>
                        </CardTitle>}

                        {!selectedItem && !data.loading && <CardText>
                            Specie non selezionata
                        </CardText>}

                        {data.loading && <CardText className="text-info">
                            Caricamento in corso<BlinkDot/><BlinkDot/><BlinkDot/>
                        </CardText>}

                        {!selectedItem && !data.loading && <a onClick={this.toggleTableModal} className="btn btn-light">Seleziona Specie</a>}
                        {selectedItem && !data.loading && !nascondiPulsanteCambio && <a onClick={this.toggleTableModal} className="btn btn-light">Cambia Specie</a>}
                    </CardBody>
                </Card>

                { error ? <div className="invalid-feedback">{error}</div> : null }
                { helpText ? <FormText>{helpText}</FormText> : null}

                <Modal isOpen={isTableModalOpen} toggle={this.toggleTableModal} size={"lg"}>
                    <ModalHeader toggle={this.toggleTableModal}>
                        Seleziona Specie
                    </ModalHeader>
                    <ModalBody>
                        {selectedItem && <div className="row" style={{marginBottom: '0.8em'}}>
                            <div className="col-8 offset-2">
                                <div className="text-danger text-center">
                                    Attenzione! Cambiando specie cambieranno anche i campi della scheda con il rischio di perdita di dati
                                </div>
                            </div>
                        </div>}
                        <ReactTable
                            loading={data.loading}
                            noDataText={"Nessuna Specie Presente"}
                            className="-highlight"
                            data={data.specieProgettos ? data.specieProgettos: []}
                            style={{maxHeight: "500px"}}
                            defaultPageSize={10}
                            nextText="Avanti"
                            previousText="Indietro"
                            loadingText="Caricamento in corso..."
                            rowsText="elementi"
                            ofText="di"
                            pageText="Pagina"
                            columns={columns} />
                    </ModalBody>
                </Modal>
            </div>
        );
    }
}

const SpeciesChooser = compose(
    graphql(speciesProgettoQuery),
)(FormField(SpeciesChooserWrapper));

SpeciesChooser.defaultProps = {};

SpeciesChooser.propTypes = {
    helpText: PropTypes.string,
    field: PropTypes.string.isRequired,
};

export default SpeciesChooser;
